<?php 
   /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/Testimonianze.php";
    
    if(isset($_GET["id"])) {
        $visualizzatoreTestimonianze = new Testimonianze($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $visualizzatoreTestimonianze->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione Testimonianza</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Testimonianza creata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==220) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Testimonianza modificata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Testimonianze</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($visualizzatoreTestimonianze)? $visualizzatoreTestimonianze->getNome() : "Nuovo visualizzatore testimonianze"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($visualizzatoreTestimonianze) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($visualizzatoreTestimonianze) ? $visualizzatoreTestimonianze->getId() : "0")); ?>">
                                
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label>Nome</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome griglia" value="<?php echo((isset($visualizzatoreTestimonianze) ? $visualizzatoreTestimonianze->getNome() : "")) ?>" placeholder="Nome occorrenza">
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="inputPassword3" >Spazio occupato</label>
                                            <select class="form-control" name="spazioOccupato">
                                            <?php 
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($visualizzatoreTestimonianze) && $visualizzatoreTestimonianze->getSpazioOccupato()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Scegli lo spazio che deve occupare la tua form nella sezione</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Tipo visualizzazione</label>
                                            <select class="form-control" name="tipoVisualizzazione">
                                                <?php
                                                    $arrayClassiElemento = array("tradizionale"=>"Tradizionale","slider"=>"Slider");
                                                    foreach($arrayClassiElemento as $classe=>$numeroELementi) {
                                                        if(isset($visualizzatoreTestimonianze) && $classe==$visualizzatoreTestimonianze->getTipoVisualizzazione()) {
                                                            echo"<option value=\"$classe\" SELECTED>{$numeroELementi}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"$classe\">{$numeroELementi}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Elementi per riga / slide</label>
                                            <select class="form-control" name="elementiPerRiga">
                                                <?php 
                                                    $opzioni = array(1,2,3,4,6);
                                                    foreach($opzioni as $i) {
                                                        if(isset($visualizzatoreTestimonianze) && $i==$visualizzatoreTestimonianze->getElementiPerRiga()) {
                                                            echo"<option value=\"$i\" SELECTED>{$i}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"$i\">{$i}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Mostra immagini</label>
                                            <input type="checkbox" class="js-switch" name="mostraImmagini" value="si" <?php echo((isset($visualizzatoreTestimonianze) && $visualizzatoreTestimonianze->getMostraImmagini()=="si") ? "checked":"") ?>>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <?php 
                                if(isset($visualizzatoreTestimonianze)) {
                            ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-4 col-xl-3 align-self-start sticky-top">
                                        <form>
                                            <div class="mb-4 add-box">
                                                <h5 class="mb-3"> Aggiungi elemento </h5>
                                                <div class="options-box">
                                                    <div class="form-group">
                                                        <label>Nome</label>
                                                        <input type="text" class="form-control" id="nomeElemento" placeholder="Nome">
                                                    </div>

                                                    <div class="form-group">
                                                        <label>Autore</label>
                                                        <input type="text" class="form-control" id="autoreElemento"  placeholder="Autore">
                                                    </div>
                                                    
                                                    <div class="form-group">
                                                        <label>Ruolo</label>
                                                        <input type="text" class="form-control" id="ruoloElemento"  placeholder="Ruolo">
                                                    </div>
                                                    
                                                    <button type="button" class="btn btn-primary float-right" value="Crea" onclick="creaElemento()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>

                                    <div id="divElencoElementi" class="col-lg-8 col-xl-9 mb-4 gerarchia-menu">
                                        <?php 
                                            $visualizzatoreTestimonianze->stampaElementi();
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <script>
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $visualizzatoreTestimonianze->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $visualizzatoreTestimonianze->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var nome   = $('#nomeElemento').val();
                var autore = $('#autoreElemento').val();
                var ruolo  = $('#ruoloElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?php echo $visualizzatoreTestimonianze->getId() ?>,
                        nome:nome,
                        ruolo:ruolo,
                        autore:autore
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?php echo $visualizzatoreTestimonianze->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
